/*:
 * @plugindesc 指定したリージョンのスイッチで通行ONOFF
 * @author ore
 *
 * @param regionId
 * @text リージョンID
 * @desc 通行制御を行う対象のリージョンID。
 * @type number
 * @default 1
 *
 * @param switchId
 * @text スイッチID
 * @desc 通行制御を行うために使用するスイッチID。
 * @type switch
 * @default 1
 *
 * @help 指定されたリージョンを特定のスイッチの状態に応じて通行可能に。
 *
 *
 */

(function() {
    var parameters = PluginManager.parameters('Regionswitch');
    var regionId = Number(parameters['regionId'] || 1);
    var switchId = Number(parameters['switchId'] || 1);

    var _Game_Map_isPassable = Game_Map.prototype.isPassable;
    
    Game_Map.prototype.isPassable = function(x, y, d) {
        var region = this.regionId(x, y);
        var switchOn = $gameSwitches.value(switchId);
        
        if (region === regionId) {
            return switchOn; 
        }
        
        return _Game_Map_isPassable.call(this, x, y, d);
    };
})();
